import sys
sys.path.append('../../')
import core.adfisher as adfisher

site_file = '../../weight.txt'
log_file = 'log.weight.remove.txt'

## Set up treatments

treatment1 = adfisher.Treatment("keptweight")
treatment1.visit_sites(site_file)

treatment2 = adfisher.Treatment("removedweight")
treatment2.visit_sites(site_file)
treatment2.remove_interest("fitness")

## Set up measurement

measurement = adfisher.Measurement()
measurement.get_age()
measurement.get_gender()
measurement.get_language()
measurement.get_interests()
measurement.get_ads(site='toi', reloads=10, delay=5)

## Run Experiment

adfisher.run_experiment(treatments=[treatment1, treatment2], measurement=measurement, 
	agents=10, blocks=100, log_file=log_file)

